@extends('layouts.app')
@section('content')
<div class="content-wrapper">
	<div class="content py-3">
		<div class="container-fluid"> 
			<div class="card border-0 shadow-custom mb-0">
				<div class="card-header border-grey">
					<h3 class="card-title">
						{{ __('user.update_user') }}
					</h3>
				</div>
				<form method="post" action="{{ route('user.update', $user->id) }}" enctype="multipart/form-data" >
					{{ csrf_field() }}
					<input name="_method" type="hidden" value="PATCH">
					
					<div class="card-body">
						@if(!empty($user->profile_picture))
							<div class="row">
								<div class="col-lg-12">
									<div class="user-image elevation-3" id="edit-image" style="background-image: url('{{ get_image_path($user->profile_picture) }}');"></div>
								</div>
							</div>
						@endif
						<div class="row mb-3">
							<div class="col-lg-12">
								<div class="user-image elevation-3 d-none" id="image-preview"></div>
							</div>
						</div>
						<div class="row">
							<div class="col-lg-12">
								<div class="form-group">
									<label for="name" class="required">{{ __('user.name') }}</label>
									<input type="text" class="form-control  @error('name') is-invalid @enderror" value="{{ $user->name }}" name="name" id="name">
									@error('name')
										<span class="d-block invalid-feedback">{{ $message }}</span>
									@enderror
								</div>
							</div>
							<div class="col-lg-6">
								<div class="form-group">
									<label for="email" class="required">{{ __('user.email') }}</label>
									<input type="text" class="form-control  @error('email') is-invalid @enderror" value="{{ $user->email }}" name="email" id="email">
									@error('email')
										<span class="d-block invalid-feedback">{{ $message }}</span>
									@enderror
								</div>
							</div>
							<div class="col-lg-6">
								<div class="form-group">
									<label for="password" class="required">{{ __('user.password') }}</label>
									<input type="password" value="{{ old('password') }}" class="form-control  @error('password') is-invalid @enderror" name="password" id="password">
									@error('password')
										<span class="d-block invalid-feedback">{{ $message }}</span>
									@enderror
								</div>
							</div>
							<div class="col-lg-6">
								@php 
									$user_role = '';
									$user_role = $user->roles->first();
									if(!empty($user_role)) {
										$user_role = $user_role->id;
									}
								@endphp
								<div class="form-group">
									<label for="js-user-role" class="required">{{ __('user.user_role') }}</label>						 
									<select class="form-control select-role  @error('role') is-invalid @enderror" name="role" id="js-user-role">
										@foreach($roles as $role)
											<option value="{{ $role->id }}" {{ $user_role == $role->id ? 'selected' : '' }}>{{ $role->name }}</option>
										@endforeach
									</select>
									@error('role')
										<span class="d-block invalid-feedback">{{ $message }}</span>
									@enderror
								</div>
							</div>
							<div class="col-lg-6">
								<div class="form-group">
									<label for="status">{{ __('user.status') }}</label> 
									<select class="form-control" name="status" id="status">
										<option value="active" {{ $user->status == 'active' ? 'selected' : '' }}>Active</option>
										<option value="disabled" {{ $user->status == 'disabled' ? 'selected' : '' }}>Disabled</option>
									</select>
								</div>
							</div>
							<div class="col-lg-12">
								<div class="form-group">
									<label for="profile_picture">{{ __('user.profile_picture') }}</label>
									<div class="input-group">
										<div class="custom-file">
											<input name="profile_picture" type="file" class="custom-file-input @error('profile_picture') is-invalid @enderror" id="profile_picture">
											<label class="custom-file-label" for="profile_picture">{{ __('user.choose_file') }}</label>
										</div>
										@error('profile_picture')
											<span class="d-block invalid-feedback">{{ $message }}</span>
										@enderror
									</div>
								</div>
							</div>
							<div class="col-lg-12"> 
								<button type="submit" class="btn btn-primary mt-1">{{ __('user.update_user') }}</button>
							</div>
						</div>
					</div>
				</form>
			</div>
		</div>
	</div>
</div>
@endsection

@section('js-script')
<!-- PAGE SPECIFIC CUSTOM SCRIPT -->
<script>
	$(function () {
		"use strict";
		// INITIALIZE SELECT2 ELEMENT
		$('.select-role').select2({
			theme: 'bootstrap4'
		})
		
		// EVENT LISTENER TO PREVIEW PROFILE IMAGE
		$('.custom-file-input').on('change', function() {
			if (this.files && this.files[0]) {
	
			var file = this.files[0];

			var reader = new FileReader();

			reader.onload = function(e) {
				$('#image-preview').css('background-image', 'url(' + e.target.result + ')');
				$('#image-preview').removeClass('d-none');
				$('#image-preview').addClass('mb-3');
				$('#edit-image').addClass('d-none');
			};

			reader.readAsDataURL(file);
			} else {
				$('#image-preview').addClass('d-none');
				$('#image-preview').removeClass('mb-3');
			}
		});

	});
</script>
@endsection

@section('styles') 
<style>
	.user-image {
		width: 200px;
		height:220px;
		background-size: cover;
		background-position:center;
	}
</style>
@endsection